<?php
/* --------------------------------------------------------------
   LayoutLoaderServiceProvider.php 2020-04-21
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Layout\Smarty;

use Gambio\Admin\Application\Token\TokenService;
use Gambio\Admin\Customer\SimpleCustomerService;
use Gambio\Admin\Layout\Menu\AdminMenuService;
use Gambio\Admin\Layout\Smarty\Loaders\BustFilesLoader;
use Gambio\Admin\Layout\Smarty\Loaders\ConfigurationDataLoader;
use Gambio\Admin\Layout\Smarty\Loaders\DirectHelpLoader;
use Gambio\Admin\Layout\Smarty\Loaders\EnvironmentLoader;
use Gambio\Admin\Layout\Smarty\Loaders\FontAwesomeFallbackLoader;
use Gambio\Admin\Layout\Smarty\Loaders\LanguagesLoader;
use Gambio\Admin\Layout\Smarty\Loaders\LegacyTemplateDataLoader;
use Gambio\Admin\Layout\Smarty\Loaders\MenuDataLoader;
use Gambio\Admin\Layout\Smarty\Loaders\SessionDataLoader;
use Gambio\Admin\Layout\Smarty\Loaders\SmartyPluginLoader;
use Gambio\Admin\Layout\Smarty\Loaders\TokenLoader;
use Gambio\Admin\Layout\Smarty\Loaders\TranslationsLoader;
use Gambio\Admin\Layout\Smarty\Loaders\UserConfigurationLoader;
use Gambio\Admin\UserConfiguration\Interfaces\CurrentUserConfigurationService;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;
use Gambio\Core\Application\ValueObjects\Path;
use Gambio\Core\Application\ValueObjects\ServerInformation;
use Gambio\Core\Application\ValueObjects\Url;
use Gambio\Core\Application\ValueObjects\UserPreferences;
use Gambio\Core\Command\Interfaces\CommandDispatcher;
use Gambio\Core\Configuration\Builder\ConfigurationFinderBuilder;
use Gambio\Core\Configuration\ConfigurationService;
use Gambio\Core\Language\LanguageService;
use Gambio\Core\Language\TextManager;

/**
 * Class LayoutLoaderServiceProvider
 *
 * @package Gambio\Admin\Layout\Smarty
 */
class LayoutLoaderServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            LayoutLoader::class,
            TemplateTranslations::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $loaders = [
            BustFilesLoader::class,
            ConfigurationDataLoader::class,
            EnvironmentLoader::class,
            FontAwesomeFallbackLoader::class,
            LanguagesLoader::class,
            MenuDataLoader::class,
            SessionDataLoader::class,
            SmartyPluginLoader::class,
            TokenLoader::class,
            TranslationsLoader::class,
            UserConfigurationLoader::class,
            DirectHelpLoader::class,
            
            LegacyTemplateDataLoader::class,
        ];
        $this->application->share(LayoutLoader::class)->addArgument(CommandDispatcher::class)->addArguments($loaders);
        
        $this->application->share(BustFilesLoader::class)->addArgument(ServerInformation::class)->addArgument(
            ConfigurationFinderBuilder::class
        );
        
        $this->application->share(ConfigurationDataLoader::class)
                          ->addArgument(ConfigurationService::class)
                          ->addArgument(Url::class);
        
        $this->application->share(EnvironmentLoader::class);
        $this->application->share(FontAwesomeFallbackLoader::class);
        
        $this->application->share(LanguagesLoader::class)->addArgument(LanguageService::class)->addArgument(
                UserPreferences::class
            );
        
        $this->application->share(LegacyTemplateDataLoader::class);
        
        $this->application->share(MenuDataLoader::class)->addArgument(AdminMenuService::class);
        
        $this->application->share(SessionDataLoader::class)->addArgument(SimpleCustomerService::class)->addArgument(
                UserPreferences::class
            );
        
        $this->application->share(SmartyPluginLoader::class)->addArgument(TextManager::class)->addArgument(
                UserPreferences::class
            );
        
        $this->application->share(TokenLoader::class)->addArgument(TokenService::class);
        
        $this->application->share(TemplateTranslations::class)->addArgument(TextManager::class)->addArgument(
                UserPreferences::class
            );
        $this->application->share(TranslationsLoader::class)->addArgument(TemplateTranslations::class);
        
        $this->application->share(UserConfigurationLoader::class)
                          ->addArgument(CurrentUserConfigurationService::class)
                          ->addArgument(TextManager::class)
                          ->addArgument(UserPreferences::class);
        
        $this->application->share(DirectHelpLoader::class)->addArgument(ConfigurationService::class)->addArgument(
                Path::class
            )->addArgument(Url::class);
    }
}